/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Wait for the deviceready event before using any of Cordova's device APIs.
// See https://cordova.apache.org/docs/en/latest/cordova/events/events.html#deviceready
document.addEventListener(
  "deviceready",
  function () {
    cordova.plugins.firebase.messaging.requestPermission({forceShow: false}).then(function() {
        console.log("Push messaging is allowed");
    });

    var deviceID = "";
    var deviceName = device.model;
    var os = device.platform + " " + device.version;

  



    cordova.plugins.firebase.messaging.getToken().then(function(token) {
        console.log("Got device token: "+token);
        deviceID = token;


        var url =
        "https://login.master-pos.com/?deviceid=" +
        deviceID +
        "&device_name=" +
        deviceName +
        "&os=" +
        os;

        var options = "location=no,_system=yes,zoom=no,toolbar=no";
        
      cordova.InAppBrowser.open(url, "_blank", options);

    });

    // cordova.plugins.firebase.messaging.onMessage(function(payload) {
    //     console.log("New foreground FCM message: "+payload);
    // });


    // cordova.plugins.firebase.messaging.onBackgroundMessage(function(payload) {
    //     console.log("New background FCM message: "+payload);
    // });


     
  
  },
  false
);
